;;
;; This example demonstrates a simple raster.
;; 
;;
;;
;; This example will compile with the MAXAM assembler
;; or the built-in assembler of WinAPE32.
;;
;; You might have to modify this file if you are using
;; a different assembler.
;;
;; (c) Kevin Thacker 2001,2002
;;
;; This source is released under the GNU Public License v2.

org &8000
nolist

.scr_set_mode equ &bc0e

;;----------------------------------------------------------

ld a,1
call scr_set_mode

;;----------------------------------------------------------
;; install a interrupt handler

;; disable interrupts
di
;; interrupt mode 1 (call to interrupt handler at &0038)
im 1

;; &c9 corresponds to the opcode RET
;; &fb corresponds to the opcode EI
;;
;; RET opcode takes 3us, EI opcode takes 1us

;; write EI:RET to interrupt handler at &0038
ld hl,&c9fb
ld (&0038),hl

;; enable interrupts
ei
;;-----------------------------------------------------------

;; select border
ld bc,&7f10
out (c),c

;; set border colour to black
ld bc,&7f54
out (c),c

;;------------------------------------------------------------

.main_loop

;;---------------------------------------
;; wait for start of vsync
;;
;; at this point the code assumes the VSYNC is not active.
;;
;; this code waits for the VSYNC to change from inactive->active
;; which signals the start of the VSYNC.

;; PPI port B
ld b,&f5

.ml1
;; read input
in a,(c)
;; transfer bit 0 into carry
;; if bit 0=1 then VSYNC is active, if bit 0=0 then VSYNC is inactive
rra
jr nc,ml1
;;----------------------------------------

;; wait for interrupt
halt

;; wait for interrupt
halt

;; wait for interrupt
halt

;; wait for interrupt
halt

;; delay so that colour change position is not visible (hidden by border
;; and horizontal flyback)
defs 20

;; Timing information:
;;
;; in this example we have waited for 4 interrupts, and we can calculate the exact
;; position and CRTC state.
;;
;; the first interrupt will occur 2 HSYNCs after the start of the VSYNC,
;; the interrupts following this will occur every 52 HSYNCs.
;; 
;; The instruction timings are shown in [] bracket's below

;; select pen to change (colour 0)
ld bc,&7f00               ;; [3]
out (c),c                 ;; [4]

;; start of table for raster colours
ld hl,raster_colours      ;; [3]
;; number of colours in the table
ld e,end_raster_colours-raster_colours   ;;[2]


.rl
;; get colour byte from table
ld a,(hl)                 ;; [2]
inc hl                    ;; [2]
;; output colour to hardware
out (c),a                 ;; [4]

;; delay so that the next colour change
;; occurs immediatly below this one
defs 64-4-2-2-1-3

dec e                     ;; [1]
jp nz,rl                  ;; [3]

jp main_loop

;;---------------------------------------------

;; these bytes represent the colours
;; they are stored in a form that can be written direct to the hardware
;; bit 7=0, bit 6=1 = Gate Array function "write colour"
;; bit 4..0 = hardware colour number
.raster_colours
defb &44
defb &55
defb &57
defb &5b
defb &4b
defb &4b
defb &5b
defb &57
defb &55
defb &44
defb &54					;; black
.end_raster_colours
